from urllib.request import urlopen

import cv2
import numpy as np
from flask import Blueprint, request, jsonify

main_blueprint = Blueprint('main', __name__)


@main_blueprint.route('/image-stats', methods=['POST', 'OPTIONS'])
def index():
    threshold = 250
    is_blur = False
    data = request.json
    req = urlopen(data.get('image_path'))
    arr = np.asarray(bytearray(req.read()), dtype=np.uint8)
    image = cv2.imdecode(arr, -1)

    # Convert image to grayscale
    gray = cv2.cvtColor(image, cv2.COLOR_BGR2GRAY)

    # Apply binary thresholding for bright spot detection
    _, binary_image = cv2.threshold(gray, 200, 255, cv2.THRESH_BINARY)

    # Apply Laplacian filter for edge detection
    laplacian = cv2.Laplacian(gray, cv2.CV_64F)

    # Calculate maximum intensity and variance
    _, max_val, _, _ = cv2.minMaxLoc(gray)
    laplacian_variance = laplacian.var()

    # Check blur condition based on variance of Laplacian image
    if laplacian_variance < threshold:
        is_blur = True
    return jsonify({"is_blur": is_blur})
